/**
 * @license Copyright (c) 2003-2017, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function(config){

	// config.uiColor = '#AADC6E';

	config.language = window.HiCo.API.trueChart.getDocLanguage();

	config.coreStyles_italic = {element: 'i', overrides: 'em'};
	config.coreStyles_bold = {element: 'b', overrides: 'strong'};
	config.allowedContent = true;
	config.enterMode = CKEDITOR.ENTER_DIV;
	config.shiftEnterMode = CKEDITOR.ENTER_DIV;
	config.resize_enabled = false;
	config.title = false;

	config.format_tags = 'div;h1;h2;h3;h4;h5;h6';
	config.format_div = {element: 'div', attributes: {'style': ''}};
	config.format_h1 = {element: 'h1', attributes: {'style': 'font-size:24px;'}};
	config.format_h2 = {element: 'h2', attributes: {'style': 'font-size:18px;'}};
	config.format_h3 = {element: 'h3', attributes: {'style': 'font-size:14px;'}};
	config.format_h4 = {element: 'h4', attributes: {'style': 'font-size:12px;'}};
	config.format_h5 = {element: 'h5', attributes: {'style': 'font-size:10px;'}};
	config.format_h6 = {element: 'h6', attributes: {'style': 'font-size:8px;'}};

	config.removeFormatTags = config.removeFormatTags + ',table,td,tr,tbody,thead,col,colgroup,pre';
	config.linkShowAdvancedTab = false;

	config.font_names =
		'Arial/Arial, sans-serif;' +
		'Arial Unicode MS/Arial Unicode MS, sans-serif;' +
		'Calibri/Calibri, sans;' +
		'Tahoma/Tahoma, sans-serif;' +
		'Verdana/Verdana, sans-serif;';
	config.font_names += HiCo.Connector.ConnectorHelper.Settings.additionalFontsForCKEditor;

	config.toolbar = [
		['ok', '-', 'AddNumber', 'RemoveNumber', '-', 'Bold', 'Italic', 'Underline', 'Strike', '-', 'TextColor', 'BGColor'],
		['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
		['NumberedList', 'BulletedList', 'Outdent', 'Indent', '-', 'Link', 'Unlink'],
		'/',
		['Format', 'Font', 'FontSize', 'varinsert'],
		['CopyFormatting', 'RemoveFormat'], // CopyFormatting needs some work, to allow copying formats across comments
		['ClearComment', 'RemoveComment']
	];

	config.plugins = [
		'autolink',
		'basicstyles',
		'colorbutton',
		'colordialog',
		'copyformatting',
		'enterkey',
		'font',
		'format',
		'indent',
		'justify',
		'link',
		'list',
		'pastefromword',
		'removeformat',
		'undo',
		// 'wysiwygarea' // for testing iframe mode

		// HiCo
		'hicoComment',
		'hicofloatingspace',
		'ok',
		'varinsert',
	].join(',');
};