(window["webpackJsonptrueChart"]=window["webpackJsonptrueChart"]||[]).push([[24],{529:function(e){e.exports=JSON.parse('{"meta":{"id":"","author":"www.trueChart.com","date":"26/08/2018 09:37:26","lastModifiedAt":"26/08/2018 09:37:26","isPublic":false,"canUpdate":true,"isBaseTemplate":true,"tcversion":"2018.10.0","modelversion":"1","title":"Time chart with deltas","description":"Creates a time chart (actual, buget, forecast) with delta as waterfall and % values.","tags":["time","variance","delta"],"thumbnail":"data:image/png;base64,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","supportinfo":"powerbi"},"data":{"content":{"instanceOf":"CellContainer","cells":[{"instanceOf":"Cell","guid":"263633cd-b097-a4bf-490d-81e221821b3d","name":"","id":"chartgrid01","isVisibleCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"isBoxUniform":false,"padding":{"instanceOf":"PaddingBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"margin":{"instanceOf":"MarginBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"border":{"instanceOf":"BorderBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true,"color":{"instanceOf":"BorderBoxColor","uniform":"rgb(0, 0, 0)","top":"rgb(0, 0, 0)","right":"rgb(0, 0, 0)","bottom":"rgb(0, 0, 0)","left":"rgb(0, 0, 0)"}},"alignment":{"horizontal":"center","vertical":"center"},"allowScrolling":true,"allowBISelection":true,"title":{"instanceOf":"CellTitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No title","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"title"},"subtitle":{"instanceOf":"CellSubtitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No subtitle","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"subtitle"},"triggers":[],"navigationVariable":{"instanceOf":"NavigationVariable","variable":"","auto":true,"value":"","useQVNav":true,"customClickBehavior":"// this example shows how to use clickInfos for performing a sense selection and sheet navigation (if not in mashUp)\\n//\\n// clickInfo.variableValue contains string info about clicked element\\n// in the following format:\\n//    <Dimension1_name>##<Dimension1_value>\xa7\xa7<Dimenison2_name>##<Dimension2_value>%%<Keyfigure_name>$$<Keyfigure_value>\\n//\\n// for example:\\n//    DD_ProdCat_ProdName##Fashion for Women or\\n//    DD_ProdCat_ProdName##0-3 Years\xa7\xa7Time_Month##12%%AC/\u0394BU$$-10697858.838721484\\n\\n/*console.log( clickInfo.variableValue );\\n\\nif( clickInfo && clickInfo.variableValueAuto )\\n{\\n   var strSplit = clickInfo.variableValue.split(\'##\')[1].split(\'\xa7\xa7\')[0];\\n\\n   // select clicked D_ProdCat category\\n   qlik.currApp().field(\\"D_ProdCat\\").selectValues([strSplit], false, false );\\n\\n   // open sheet \'correct scaling\' if we\'re not in a mashup\\n   if( !contextType.isMashup )\\n   {\\n      qlik.navigation.gotoSheet(\'zjjKdBx\');\\n   }\\n}*/","check":{"default":true,"custom":false}},"background":{"instanceOf":"CellBackground","url":{"instanceOf":"Expression","formula":"","type":"tc"},"isActive":true,"color":"#ffffff","repeat":"no-repeat","positionX":"center","positionY":"center","size":"auto","opacity":"1"},"content":{"instanceOf":"Grid","cellContainers":[{"instanceOf":"CellContainer","cells":[{"instanceOf":"Cell","guid":"d74b8239-1cf7-ac0a-4813-f4b47194a62c","name":"SubTitle","id":"chart7","isVisibleCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"isBoxUniform":false,"padding":{"instanceOf":"PaddingBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"margin":{"instanceOf":"MarginBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"border":{"instanceOf":"BorderBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true,"color":{"instanceOf":"BorderBoxColor","uniform":"#000000","top":"#000000","right":"#000000","bottom":"#000000","left":"#000000"}},"alignment":{"horizontal":"center","vertical":"center"},"allowScrolling":false,"allowBISelection":true,"title":{"instanceOf":"CellTitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No title","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"title"},"subtitle":{"instanceOf":"CellSubtitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No subtitle","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"subtitle"},"triggers":[{"instanceOf":"Trigger","type":"click","name":"","actions":[{"instanceOf":"TriggerAction","inOrder":false,"name":"none","paramsExpr":{},"optionalParamsExpr":[]}]}],"navigationVariable":{"instanceOf":"NavigationVariable","variable":"","auto":true,"value":"","useQVNav":true,"customClickBehavior":"// this example shows how to use clickInfos for performing a sense selection and sheet navigation (if not in mashUp)\\n//\\n// clickInfo.variableValue contains string info about clicked element\\n// in the following format:\\n//    <Dimension1_name>##<Dimension1_value>\xa7\xa7<Dimenison2_name>##<Dimension2_value>%%<Keyfigure_name>$$<Keyfigure_value>\\n//\\n// for example:\\n//    DD_ProdCat_ProdName##Fashion for Women or\\n//    DD_ProdCat_ProdName##0-3 Years\xa7\xa7Time_Month##12%%AC/\u0394BU$$-10697858.838721484\\n\\n/*console.log( clickInfo.variableValue );\\n\\nif( clickInfo && clickInfo.variableValueAuto )\\n{\\n   var strSplit = clickInfo.variableValue.split(\'##\')[1].split(\'\xa7\xa7\')[0];\\n\\n   // select clicked D_ProdCat category\\n   qlik.currApp().field(\\"D_ProdCat\\").selectValues([strSplit], false, false );\\n\\n   // open sheet \'correct scaling\' if we\'re not in a mashup\\n   if( !contextType.isMashup )\\n   {\\n      qlik.navigation.gotoSheet(\'zjjKdBx\');\\n   }\\n}*/","check":{"default":true,"custom":false}},"background":{"instanceOf":"CellBackground","url":{"instanceOf":"Expression","formula":"","type":"tc"},"isActive":false,"color":"#ffffff","repeat":"no-repeat","positionX":"center","positionY":"center","size":"auto","opacity":"1"},"content":{"instanceOf":"Button","type":"simple","state":{"instanceOf":"Expression","formula":"normal","type":"sense"},"icon":{"instanceOf":"Expression","formula":"fa-th-list","type":"sense"},"label":{"instanceOf":"Expression","formula":"Chart Title","type":"sense"},"tooltip":{"instanceOf":"Expression","formula":"","type":"sense"},"layout":{"instanceOf":"ButtonLayout","size":{"instanceOf":"ButtonSize","width":"","height":""},"alignment":{"instanceOf":"ButtonLayoutAlignment","buttonHorizontal":"center","buttonVertical":"center","contentHorizontal":"left","contentVertical":"center"},"textAlignment":"center","iconPosition":"left","padding":"","margin":""},"style":{"instanceOf":"ButtonStyle","custom":{"instanceOf":"Expression","formula":"","type":"sense"},"font":{"instanceOf":"ButtonStyleFont","family":{"instanceOf":"Expression","formula":"","type":"sense"},"weight":{"instanceOf":"Expression","formula":"","type":"sense"},"style":{"instanceOf":"Expression","formula":"","type":"sense"},"size":{"instanceOf":"Expression","formula":"","type":"sense"},"color":{"instanceOf":"ButtonColor","default":{"instanceOf":"Expression","formula":"","type":"sense"},"hover":{"instanceOf":"Expression","formula":"","type":"sense"}}},"icon":{"instanceOf":"ButtonStyleIcon","size":0,"color":{"instanceOf":"ButtonColor","default":{"instanceOf":"Expression","formula":"","type":"sense"},"hover":{"instanceOf":"Expression","formula":"","type":"sense"}}},"background":{"instanceOf":"ButtonStyleBackground","image":{"instanceOf":"Expression","formula":"../extensions/trueChart/img/logo.png","type":"sense"},"position":{"horizontal":"center","vertical":"center"},"size":"","repeat":"no-repeat","color":{"instanceOf":"ButtonColor","default":{"instanceOf":"Expression","formula":"","type":"sense"},"hover":{"instanceOf":"Expression","formula":"=white()","type":"sense"}}},"border":{"instanceOf":"ButtonStyleBorder","color":{"instanceOf":"ButtonColor","default":{"instanceOf":"Expression","formula":"","type":"sense"},"hover":{"instanceOf":"Expression","formula":"","type":"sense"}},"radius":"","width":"","style":"","enabled":"undefined"},"boxShadow":""}}}]},{"instanceOf":"CellContainer","cells":[{"instanceOf":"Cell","guid":"51eede24-9d04-a37b-4910-6a00b7c807e2","name":"","id":"chart1","isVisibleCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"isBoxUniform":false,"padding":{"instanceOf":"PaddingBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"margin":{"instanceOf":"MarginBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"border":{"instanceOf":"BorderBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true,"color":{"instanceOf":"BorderBoxColor","uniform":"rgb(0, 0, 0)","top":"rgb(0, 0, 0)","right":"rgb(0, 0, 0)","bottom":"rgb(0, 0, 0)","left":"rgb(0, 0, 0)"}},"alignment":{"horizontal":"center","vertical":"center"},"allowScrolling":true,"allowBISelection":true,"title":{"instanceOf":"CellTitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No title","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"title"},"subtitle":{"instanceOf":"CellSubtitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No subtitle","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"subtitle"},"triggers":[],"navigationVariable":{"instanceOf":"NavigationVariable","variable":"","auto":true,"value":"","useQVNav":true,"customClickBehavior":"// this example shows how to use clickInfos for performing a sense selection and sheet navigation (if not in mashUp)\\n//\\n// clickInfo.variableValue contains string info about clicked element\\n// in the following format:\\n//    <Dimension1_name>##<Dimension1_value>\xa7\xa7<Dimenison2_name>##<Dimension2_value>%%<Keyfigure_name>$$<Keyfigure_value>\\n//\\n// for example:\\n//    DD_ProdCat_ProdName##Fashion for Women or\\n//    DD_ProdCat_ProdName##0-3 Years\xa7\xa7Time_Month##12%%AC/\u0394BU$$-10697858.838721484\\n\\n/*console.log( clickInfo.variableValue );\\n\\nif( clickInfo && clickInfo.variableValueAuto )\\n{\\n   var strSplit = clickInfo.variableValue.split(\'##\')[1].split(\'\xa7\xa7\')[0];\\n\\n   // select clicked D_ProdCat category\\n   qlik.currApp().field(\\"D_ProdCat\\").selectValues([strSplit], false, false );\\n\\n   // open sheet \'correct scaling\' if we\'re not in a mashup\\n   if( !contextType.isMashup )\\n   {\\n      qlik.navigation.gotoSheet(\'zjjKdBx\');\\n   }\\n}*/","check":{"default":true,"custom":false}},"background":{"instanceOf":"CellBackground","url":{"instanceOf":"Expression","formula":"","type":"tc"},"isActive":false,"color":"#ffffff","repeat":"no-repeat","positionX":"center","positionY":"center","size":"auto","opacity":"1"},"content":{"instanceOf":"Grid","cellContainers":[{"instanceOf":"CellContainer","cells":[{"instanceOf":"Cell","guid":"2878c9c4-51f4-03c5-4a64-0ad8adfca01d","name":"TimeChartValues","id":"chart6","isVisibleCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"isBoxUniform":false,"padding":{"instanceOf":"PaddingBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"margin":{"instanceOf":"MarginBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"border":{"instanceOf":"BorderBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true,"color":{"instanceOf":"BorderBoxColor","uniform":"#000000","top":"#000000","right":"#000000","bottom":"#000000","left":"#000000"}},"alignment":{"horizontal":"center","vertical":"bottom"},"allowScrolling":true,"allowBISelection":true,"title":{"instanceOf":"CellTitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No title","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"title"},"subtitle":{"instanceOf":"CellSubtitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No subtitle","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"subtitle"},"triggers":[],"navigationVariable":{"instanceOf":"NavigationVariable","variable":"","auto":true,"value":"","useQVNav":true,"customClickBehavior":"","check":{"default":true,"custom":false}},"background":{"instanceOf":"CellBackground","url":{"instanceOf":"Expression","formula":"","type":"tc"},"isActive":false,"color":"#ffffff","repeat":"no-repeat","positionX":"center","positionY":"center","size":"auto","opacity":"1"},"content":{"instanceOf":"TimeChart","contextId":"2cZue00000","doStack":false,"stack":{"instanceOf":"ChartMeasureStack","type":"normal","showAsFormulas":[{"instanceOf":"Formula","id":0,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"}}],"label":{"instanceOf":"ChartMeasureStackLabel","showAs":"none","position":"center","alignment":"inline","isVisible":true,"showUnits":false,"doesOverlapSelf":false,"doesOverlapOthers":false},"line":"none"},"measures":[{"instanceOf":"ChartMeasure","id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr5","name":"\u0394 BUD%","type":"value","biColumnId":"GngBgs","showRestAsValue":true,"showSubtotalAsValue":true,"showTotalAsValue":true,"notation":"element","concept":"color","valueLabelOpt":"all","valueLabelFunctions":[{"instanceOf":"Formula","id":0,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"}}],"valueLabelType":"normal","valueLabelBackground":"transparent","showUnit":true,"outlier":{"instanceOf":"MeasureOutlier","isActive":false,"operator":">=","value":"","label":"value","useSymbol":true,"style":"symbol_value"},"scaling":{"instanceOf":"MeasureScaling","isActive":false,"legendShow":"none","legendDisplace":"none","showLegendSign":false},"valueLabelOverlapSelf":true,"valueLabelOverlapOthers":false,"legend":{"instanceOf":"ChartMeasureLegend","position":"start_axis","displacement":"none","connector":"none","inGrid":true},"reference":"Zero","referenceConcept":"area","labelPosition":"center","stackOrder":-1,"sequence":1}],"compares":[],"highlights":[],"categories":{"instanceOf":"TimeCategory","showAt":"none","gaps":[],"categoriesWithoutTotals":"categoryWithoutValuesType.1","separator":{"instanceOf":"CategorySeparator","category":false,"timeType":false,"scenario":false},"labels":[{"instanceOf":"CategoryLabel","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"maxLength":-1,"dimAutoLength":true,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.dim0"}],"additionalWidth":0,"hasCategoryDistanceMultiplier":false,"selectedMeasure":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr5","sepFromNotation":true,"sepSubtotalFromNotation":true,"sepTotalFromNotation":false,"sepTotalWVFromNotation":true,"sepLengthStartAuto":true,"sepSubtotalLengthStartAuto":true,"sepTotalLengthStartAuto":false,"sepTotalWVLengthStartAuto":true,"sepLengthStart_factor":100,"sepLengthStart_mmpt":0,"sepLengthStartUnit":"%","sepSubtotalLengthStart_factor":100,"sepSubtotalLengthStart_mmpt":0,"sepSubtotalLengthStartUnit":"%","sepTotalLengthStart_factor":50,"sepTotalLengthStart_mmpt":0,"sepTotalLengthStartUnit":"%","sepTotalWVLengthStart_factor":20,"sepTotalWVLengthStart_mmpt":0,"sepTotalWVLengthStartUnit":"%","sepEndFromNotation":true,"sepSubtotalEndFromNotation":true,"sepTotalEndFromNotation":false,"sepTotalWVEndFromNotation":true,"sepLengthEnd_factor":100,"sepLengthEnd_mmpt":0,"sepLengthEndUnit":"%","sepSubtotalLengthEnd_factor":100,"sepSubtotalLengthEnd_mmpt":0,"sepSubtotalLengthEndUnit":"%","sepTotalLengthEnd_factor":50,"sepTotalLengthEnd_mmpt":0,"sepTotalLengthEndUnit":"%","sepTotalWVLengthEnd_factor":20,"sepTotalWVLengthEnd_mmpt":0,"sepTotalWVLengthEndUnit":"%","alignment":{"instanceOf":"TimeCategoryAlignment","horizontal":"left","vertical":"top"}}}}]},{"instanceOf":"CellContainer","cells":[{"instanceOf":"Cell","guid":"373a40bc-b36d-d833-4a78-34387f7e3d4a","name":"TimeChartWaterfall","id":"chart2","isVisibleCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"isBoxUniform":false,"padding":{"instanceOf":"PaddingBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"margin":{"instanceOf":"MarginBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"border":{"instanceOf":"BorderBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true,"color":{"instanceOf":"BorderBoxColor","uniform":"rgb(0, 0, 0)","top":"rgb(0, 0, 0)","right":"rgb(0, 0, 0)","bottom":"rgb(0, 0, 0)","left":"rgb(0, 0, 0)"}},"alignment":{"horizontal":"center","vertical":"bottom"},"allowScrolling":true,"allowBISelection":true,"title":{"instanceOf":"CellTitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No title","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"title"},"subtitle":{"instanceOf":"CellSubtitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No subtitle","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"subtitle"},"triggers":[],"navigationVariable":{"instanceOf":"NavigationVariable","variable":"","auto":true,"value":"","useQVNav":true,"customClickBehavior":"","check":{"default":true,"custom":false}},"background":{"instanceOf":"CellBackground","url":{"instanceOf":"Expression","formula":"","type":"tc"},"isActive":false,"color":"#ffffff","repeat":"no-repeat","positionX":"center","positionY":"center","size":"auto","opacity":"1"},"content":{"instanceOf":"TimeChart","contextId":"2cZue00000","doStack":false,"stack":{"instanceOf":"ChartMeasureStack","type":"normal","showAsFormulas":[{"instanceOf":"Formula","id":0,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"}}],"label":{"instanceOf":"ChartMeasureStackLabel","showAs":"none","position":"center","alignment":"inline","isVisible":true,"showUnits":false,"doesOverlapSelf":false,"doesOverlapOthers":false},"line":"none"},"measures":[{"instanceOf":"ChartMeasure","id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr4","name":"\u0394 BUD","type":"waterfall","biColumnId":"pUmL","showRestAsValue":true,"showSubtotalAsValue":true,"showTotalAsValue":true,"notation":"element","concept":"area_color","valueLabelOpt":"all","valueLabelFunctions":[{"instanceOf":"Formula","id":0,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"}}],"valueLabelType":"normal","valueLabelBackground":"transparent","showUnit":true,"outlier":{"instanceOf":"MeasureOutlier","isActive":false,"operator":">=","value":"","label":"value","useSymbol":true,"style":"symbol_value"},"scaling":{"instanceOf":"MeasureScaling","isActive":false,"legendShow":"none","legendDisplace":"none","showLegendSign":false},"valueLabelOverlapSelf":true,"valueLabelOverlapOthers":false,"legend":{"instanceOf":"ChartMeasureLegend","position":"start_center","displacement":"none","connector":"none","inGrid":true},"reference":"Zero","referenceConcept":"area","labelPosition":"center","stackOrder":-1,"sequence":1}],"compares":[],"highlights":[],"categories":{"instanceOf":"TimeCategory","showAt":"none","gaps":[],"categoriesWithoutTotals":"categoryWithoutValuesType.1","separator":{"instanceOf":"CategorySeparator","category":false,"timeType":false,"scenario":false},"labels":[{"instanceOf":"CategoryLabel","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"maxLength":-1,"dimAutoLength":true,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.dim0"}],"additionalWidth":0,"hasCategoryDistanceMultiplier":false,"selectedMeasure":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr4","sepFromNotation":true,"sepSubtotalFromNotation":true,"sepTotalFromNotation":false,"sepTotalWVFromNotation":true,"sepLengthStartAuto":true,"sepSubtotalLengthStartAuto":true,"sepTotalLengthStartAuto":false,"sepTotalWVLengthStartAuto":true,"sepLengthStart_factor":100,"sepLengthStart_mmpt":0,"sepLengthStartUnit":"%","sepSubtotalLengthStart_factor":100,"sepSubtotalLengthStart_mmpt":0,"sepSubtotalLengthStartUnit":"%","sepTotalLengthStart_factor":50,"sepTotalLengthStart_mmpt":0,"sepTotalLengthStartUnit":"%","sepTotalWVLengthStart_factor":20,"sepTotalWVLengthStart_mmpt":0,"sepTotalWVLengthStartUnit":"%","sepEndFromNotation":true,"sepSubtotalEndFromNotation":true,"sepTotalEndFromNotation":false,"sepTotalWVEndFromNotation":true,"sepLengthEnd_factor":100,"sepLengthEnd_mmpt":0,"sepLengthEndUnit":"%","sepSubtotalLengthEnd_factor":100,"sepSubtotalLengthEnd_mmpt":0,"sepSubtotalLengthEndUnit":"%","sepTotalLengthEnd_factor":50,"sepTotalLengthEnd_mmpt":0,"sepTotalLengthEndUnit":"%","sepTotalWVLengthEnd_factor":20,"sepTotalWVLengthEnd_mmpt":0,"sepTotalWVLengthEndUnit":"%","alignment":{"instanceOf":"TimeCategoryAlignment","horizontal":"left","vertical":"top"}}}}]},{"instanceOf":"CellContainer","cells":[{"instanceOf":"Cell","guid":"257451b3-cadb-433a-49af-1774a61d8ce9","name":"TimeChartMain","id":"chart4","isVisibleCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"isBoxUniform":false,"padding":{"instanceOf":"PaddingBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"margin":{"instanceOf":"MarginBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true},"border":{"instanceOf":"BorderBox","width":{"instanceOf":"BoxWidth","uniform":0,"top":0,"right":0,"bottom":0,"left":0},"isActive":true,"color":{"instanceOf":"BorderBoxColor","uniform":"#000000","top":"#000000","right":"#000000","bottom":"#000000","left":"#000000"}},"alignment":{"horizontal":"center","vertical":"bottom"},"allowScrolling":true,"allowBISelection":true,"title":{"instanceOf":"CellTitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No title","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"title"},"subtitle":{"instanceOf":"CellSubtitle","keyCondition":"","isVisible":"true","isVisibleCondition":"Yes","isEditable":"true","isEditableCondition":"Yes","isAutoSave":true,"text":"","defaultText":"No subtitle","showDefaultText":true,"textType":"","loggable":true,"isActive":false,"transport":"active","titleLabelType":"subtitle"},"triggers":[],"navigationVariable":{"instanceOf":"NavigationVariable","variable":"","auto":true,"value":"","useQVNav":true,"customClickBehavior":"","check":{"default":true,"custom":false}},"background":{"instanceOf":"CellBackground","url":{"instanceOf":"Expression","formula":"","type":"tc"},"isActive":false,"color":"#ffffff","repeat":"no-repeat","positionX":"center","positionY":"center","size":"auto","opacity":"1"},"content":{"instanceOf":"TimeChart","contextId":"2cZue00000","doStack":false,"stack":{"instanceOf":"ChartMeasureStack","type":"normal","showAsFormulas":[{"instanceOf":"Formula","id":0,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"}}],"label":{"instanceOf":"ChartMeasureStackLabel","showAs":"none","position":"center","alignment":"inline","isVisible":true,"showUnits":false,"doesOverlapSelf":false,"doesOverlapOthers":false},"line":"none"},"measures":[{"instanceOf":"ChartMeasure","id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr0","name":"Sales Amount ACT","type":"bar","biColumnId":"mGjcwAN","showRestAsValue":true,"showSubtotalAsValue":true,"showTotalAsValue":true,"notation":"element","concept":"area","valueLabelOpt":"function","valueLabelFunctions":[{"instanceOf":"Formula","id":1,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"$(K01)","type":"tc"}}],"valueLabelType":"normal","valueLabelBackground":"transparent","showUnit":true,"outlier":{"instanceOf":"MeasureOutlier","isActive":false,"operator":">=","value":"","label":"value","useSymbol":true,"style":"symbol_value"},"scaling":{"instanceOf":"MeasureScaling","isActive":false,"legendShow":"none","legendDisplace":"none","showLegendSign":false},"valueLabelOverlapSelf":true,"valueLabelOverlapOthers":false,"legend":{"instanceOf":"ChartMeasureLegend","position":"start_value","displacement":"none","connector":"notation","inGrid":true},"reference":"Zero","referenceConcept":"area","labelPosition":"center","stackOrder":-1,"sequence":1},{"instanceOf":"ChartMeasure","id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr1","name":"Sales Amount PY","type":"bar","biColumnId":"yMaeM","showRestAsValue":true,"showSubtotalAsValue":true,"showTotalAsValue":true,"notation":"element","concept":"area","valueLabelOpt":"none","valueLabelFunctions":[{"instanceOf":"Formula","id":0,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"}}],"valueLabelType":"normal","valueLabelBackground":"transparent","showUnit":true,"outlier":{"instanceOf":"MeasureOutlier","isActive":false,"operator":">=","value":"","label":"value","useSymbol":true,"style":"symbol_value"},"scaling":{"instanceOf":"MeasureScaling","isActive":false,"legendShow":"none","legendDisplace":"none","showLegendSign":false},"valueLabelOverlapSelf":true,"valueLabelOverlapOthers":false,"legend":{"instanceOf":"ChartMeasureLegend","position":"start_center","displacement":"none","connector":"notation","inGrid":true},"reference":"Zero","referenceConcept":"area","labelPosition":"left","stackOrder":-1,"sequence":1},{"instanceOf":"ChartMeasure","id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr2","name":"Sales Amount BUD","type":"bar","biColumnId":"qmaTQ","showRestAsValue":true,"showSubtotalAsValue":true,"showTotalAsValue":true,"notation":"element","concept":"area","valueLabelOpt":"none","valueLabelFunctions":[{"instanceOf":"Formula","id":0,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"}}],"valueLabelType":"normal","valueLabelBackground":"transparent","showUnit":true,"outlier":{"instanceOf":"MeasureOutlier","isActive":false,"operator":">=","value":"","label":"value","useSymbol":true,"style":"symbol_value"},"scaling":{"instanceOf":"MeasureScaling","isActive":false,"legendShow":"none","legendDisplace":"none","showLegendSign":false},"valueLabelOverlapSelf":true,"valueLabelOverlapOthers":false,"legend":{"instanceOf":"ChartMeasureLegend","position":"end_center","displacement":"none","connector":"notation","inGrid":true},"reference":"Zero","referenceConcept":"area","labelPosition":"right","stackOrder":-1,"sequence":1},{"instanceOf":"ChartMeasure","id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr3","name":"Sales Amount FC1","type":"bar","biColumnId":"MZyeB","showRestAsValue":true,"showSubtotalAsValue":true,"showTotalAsValue":true,"notation":"element","concept":"area","valueLabelOpt":"function","valueLabelFunctions":[{"instanceOf":"Formula","id":1,"appliesTo":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"$(K04)","type":"tc"}}],"valueLabelType":"normal","valueLabelBackground":"transparent","showUnit":true,"outlier":{"instanceOf":"MeasureOutlier","isActive":false,"operator":">=","value":"","label":"value","useSymbol":true,"style":"symbol_value"},"scaling":{"instanceOf":"MeasureScaling","isActive":false,"legendShow":"none","legendDisplace":"none","showLegendSign":false},"valueLabelOverlapSelf":true,"valueLabelOverlapOthers":false,"legend":{"instanceOf":"ChartMeasureLegend","position":"end_value","displacement":"none","connector":"notation","inGrid":true},"reference":"Zero","referenceConcept":"area","labelPosition":"center","stackOrder":-1,"sequence":1}],"compares":[],"highlights":[],"categories":{"instanceOf":"TimeCategory","showAt":"axis","gaps":[],"categoriesWithoutTotals":"categoryWithoutValuesType.1","separator":{"instanceOf":"CategorySeparator","category":false,"timeType":false,"scenario":false},"labels":[{"instanceOf":"CategoryLabel","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"maxLength":-1,"dimAutoLength":true,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.dim0"}],"additionalWidth":0,"hasCategoryDistanceMultiplier":false,"selectedMeasure":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr0","sepFromNotation":true,"sepSubtotalFromNotation":true,"sepTotalFromNotation":false,"sepTotalWVFromNotation":true,"sepLengthStartAuto":true,"sepSubtotalLengthStartAuto":true,"sepTotalLengthStartAuto":false,"sepTotalWVLengthStartAuto":true,"sepLengthStart_factor":100,"sepLengthStart_mmpt":0,"sepLengthStartUnit":"%","sepSubtotalLengthStart_factor":100,"sepSubtotalLengthStart_mmpt":0,"sepSubtotalLengthStartUnit":"%","sepTotalLengthStart_factor":50,"sepTotalLengthStart_mmpt":0,"sepTotalLengthStartUnit":"%","sepTotalWVLengthStart_factor":20,"sepTotalWVLengthStart_mmpt":0,"sepTotalWVLengthStartUnit":"%","sepEndFromNotation":true,"sepSubtotalEndFromNotation":true,"sepTotalEndFromNotation":false,"sepTotalWVEndFromNotation":true,"sepLengthEnd_factor":100,"sepLengthEnd_mmpt":0,"sepLengthEndUnit":"%","sepSubtotalLengthEnd_factor":100,"sepSubtotalLengthEnd_mmpt":0,"sepSubtotalLengthEndUnit":"%","sepTotalLengthEnd_factor":50,"sepTotalLengthEnd_mmpt":0,"sepTotalLengthEndUnit":"%","sepTotalWVLengthEnd_factor":20,"sepTotalWVLengthEnd_mmpt":0,"sepTotalWVLengthEndUnit":"%","alignment":{"instanceOf":"TimeCategoryAlignment","horizontal":"left","vertical":"top"}}}}]}],"columns":[{"instanceOf":"GridDimensionColumn","size":{"instanceOf":"GridDimensionSize","type":"w","value":1,"minimum":25},"isOptimizable":true}],"rows":[{"instanceOf":"GridDimensionRow","size":{"instanceOf":"GridDimensionSize","type":"w","value":1,"minimum":25},"isOptimizable":true,"wrapCells":false},{"instanceOf":"GridDimensionRow","size":{"instanceOf":"GridDimensionSize","type":"w","value":2,"minimum":25},"isOptimizable":true,"wrapCells":false},{"instanceOf":"GridDimensionRow","size":{"instanceOf":"GridDimensionSize","type":"w","value":4,"minimum":25},"isOptimizable":true,"wrapCells":false}]}}]}],"columns":[{"instanceOf":"GridDimensionColumn","size":{"instanceOf":"GridDimensionSize","type":"w","value":1,"minimum":25},"isOptimizable":true}],"rows":[{"instanceOf":"GridDimensionRow","size":{"instanceOf":"GridDimensionSize","type":"px","value":25,"minimum":25},"isOptimizable":false,"wrapCells":false},{"instanceOf":"GridDimensionRow","size":{"instanceOf":"GridDimensionSize","type":"w","value":1,"minimum":25},"isOptimizable":true,"wrapCells":false}]}}]},"contentVersion":3,"dataContexts":[{"instanceOf":"DataContext","version":3,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1","contextId":"2cZue00000","name":"Time","tags":[],"description":"","dimensionCounter":1,"dimensions":[{"instanceOf":"DataDimension","biName":{"instanceOf":"Expression","formula":"Month","type":"sense"},"customName":{"instanceOf":"Expression","formula":"","type":"tc"},"tags":[],"description":"","definition":{"instanceOf":"Expression","formula":"Calendar.Month","type":"sense"},"showNullDimensions":true,"timeFormat":{"instanceOf":"DataDimensionTimeFormat","isActive":false,"year":{"instanceOf":"DataDimensionTimeFormatEntry","format":"none"},"quarter":{"instanceOf":"DataDimensionTimeFormatEntry","format":"none"},"month":{"instanceOf":"DataDimensionTimeFormatEntry","format":"none"},"week":{"instanceOf":"DataDimensionTimeFormatEntry","format":"none"},"day":{"instanceOf":"DataDimensionTimeFormatEntry","format":"none"}},"sorting":{"instanceOf":"DataDimensionSorting","isActive":false,"order":"none","unit":"%","value":100,"target":"dimSortingTargetType.0","condition":{"instanceOf":"Expression","formula":"","type":"tc"}},"additions":{"instanceOf":"DataDimensionAdditions","isFirstActive":false,"isRestActive":false,"isTotalActive":false,"first":{"instanceOf":"Expression","formula":"","type":"tc"},"rest":{"instanceOf":"Expression","formula":"","type":"tc"},"total":{"instanceOf":"Expression","formula":"Total","type":"tc"},"restOrder":"bottom","totalOrder":"bottom","showAsTotal":false,"showHierarchically":false,"additionsFirstBI":false,"additionsRestBI":true,"additionsTotalBI":true},"drilldownDimensions":[],"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.dim0","biColumnId":"FJhmxu","displayId":"D0100","subDimensionCounter":0,"name":{"instanceOf":"Expression","formula":"Month","type":"sense"},"displayCondition":{"instanceOf":"Expression","formula":"","type":"tc"}}],"measures":[{"instanceOf":"DataMeasure","biName":{"instanceOf":"Expression","formula":"Sales Amount ACT","type":"sense"},"customName":{"instanceOf":"Expression","formula":"","type":"tc"},"originatesFromBI":true,"definition":{"instanceOf":"Expression","formula":"sum(\\r\\n  {<\\n    $(vT_IgnoreSelections),\\n    [%Date]={\\">=$(vD_YTD_From)<$(vD_NACM)\\"},\\n    [Facts.Keyfigure] = {Sales},\\n    [Facts.Valuetype] = {Amount},\\n    [Facts.Datetype] = {ACT}\\n  >} \\n  [Facts.Value]\\n)    ","type":"sense"},"tags":[],"description":"","scalingGroup":"EUR","rules":[{"instanceOf":"DataMeasureRule","name":"New 0","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"type":"amount","value":"normal","factor":{"instanceOf":"Expression","formula":"1000","type":"tc"},"decimals":{"instanceOf":"Expression","formula":"0","type":"tc"},"unit":{"instanceOf":"Expression","formula":"","type":"tc"},"invertRating":false,"invertSign":false,"base":{"instanceOf":"DataMeasureRuleSetBase","time":"present","scenario":"actual","version":"ACT0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0, 0, 0)","border":"rgb(0, 0, 0)","pattern":"rgb(0, 0, 0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}}},"reference":{"instanceOf":"DataMeasureRuleSetReference","time":"present","scenario":"actual","version":"ACT0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0, 0, 0)","border":"rgb(0, 0, 0)","pattern":"rgb(0, 0, 0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}},"isActive":false}}],"expressions":[{"instanceOf":"DataMeasureExpression","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"formula":{"instanceOf":"Expression","formula":"0","type":"tc"},"calculationType":"summation"}],"inlineCommentType":"","markedForDeletion":false,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr0","biColumnId":"mGjcwAN","name":{"instanceOf":"Expression","formula":"Sales Amount ACT","type":"sense"},"displayCondition":{"instanceOf":"Expression","formula":"","type":"tc"}},{"instanceOf":"DataMeasure","biName":{"instanceOf":"Expression","formula":"Sales Amount PY","type":"sense"},"customName":{"instanceOf":"Expression","formula":"","type":"tc"},"originatesFromBI":true,"definition":{"instanceOf":"Expression","formula":"sum(\\r\\n  {<\\n    $(vT_IgnoreSelections),\\n    [%Date]={\\">=$(vD_LYTD_From)<=$(vD_LYTD_To)\\"},\\n    [Facts.Keyfigure] = {Sales},\\n    [Facts.Valuetype] = {Amount},\\n    [Facts.Datetype] = {ACT}\\n  >} \\n  [Facts.Value]\\n)","type":"sense"},"tags":[],"description":"","scalingGroup":"EUR","rules":[{"instanceOf":"DataMeasureRule","name":"New 0","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"type":"amount","value":"normal","factor":{"instanceOf":"Expression","formula":"1000","type":"tc"},"decimals":{"instanceOf":"Expression","formula":"0","type":"tc"},"unit":{"instanceOf":"Expression","formula":"","type":"tc"},"invertRating":false,"invertSign":false,"base":{"instanceOf":"DataMeasureRuleSetBase","time":"past","scenario":"actual","version":"ACT0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0, 0, 0)","border":"rgb(0, 0, 0)","pattern":"rgb(0, 0, 0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}}},"reference":{"instanceOf":"DataMeasureRuleSetReference","time":"present","scenario":"actual","version":"ACT0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0, 0, 0)","border":"rgb(0, 0, 0)","pattern":"rgb(0, 0, 0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}},"isActive":false}}],"expressions":[{"instanceOf":"DataMeasureExpression","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"formula":{"instanceOf":"Expression","formula":"0","type":"tc"},"calculationType":"summation"}],"inlineCommentType":"","markedForDeletion":false,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr1","biColumnId":"yMaeM","name":{"instanceOf":"Expression","formula":"Sales Amount PY","type":"sense"},"displayCondition":{"instanceOf":"Expression","formula":"","type":"tc"}},{"instanceOf":"DataMeasure","biName":{"instanceOf":"Expression","formula":"Sales Amount BUD","type":"sense"},"customName":{"instanceOf":"Expression","formula":"","type":"tc"},"originatesFromBI":true,"definition":{"instanceOf":"Expression","formula":"sum(\\r\\n  {<\\n    $(vT_IgnoreSelections),\\n    [%Date]={\\">=$(vD_YTD_From)<=$(vD_YTD_To)\\"},\\n    [Facts.Keyfigure] = {Sales},\\n    [Facts.Valuetype] = {Amount},\\n    [Facts.Datetype] = {BUD}\\n  >} \\n  [Facts.Value]\\n)    ","type":"sense"},"tags":[],"description":"","scalingGroup":"EUR","rules":[{"instanceOf":"DataMeasureRule","name":"New 0","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"type":"amount","value":"normal","factor":{"instanceOf":"Expression","formula":"1000","type":"tc"},"decimals":{"instanceOf":"Expression","formula":"0","type":"tc"},"unit":{"instanceOf":"Expression","formula":"","type":"tc"},"invertRating":false,"invertSign":false,"base":{"instanceOf":"DataMeasureRuleSetBase","time":"present","scenario":"budget","version":"BUD0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0, 0, 0)","border":"rgb(0, 0, 0)","pattern":"rgb(0, 0, 0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}}},"reference":{"instanceOf":"DataMeasureRuleSetReference","time":"present","scenario":"actual","version":"ACT0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0, 0, 0)","border":"rgb(0, 0, 0)","pattern":"rgb(0, 0, 0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}},"isActive":false}}],"expressions":[{"instanceOf":"DataMeasureExpression","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"formula":{"instanceOf":"Expression","formula":"0","type":"tc"},"calculationType":"summation"}],"inlineCommentType":"","markedForDeletion":false,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr2","biColumnId":"qmaTQ","name":{"instanceOf":"Expression","formula":"Sales Amount BUD","type":"sense"},"displayCondition":{"instanceOf":"Expression","formula":"","type":"tc"}},{"instanceOf":"DataMeasure","biName":{"instanceOf":"Expression","formula":"Sales Amount FC1","type":"sense"},"customName":{"instanceOf":"Expression","formula":"","type":"tc"},"originatesFromBI":true,"definition":{"instanceOf":"Expression","formula":"sum( \\r\\n\\t{<\\n      $(vT_IgnoreSelections),\\n    [%Date]={\\">$(vD_ACM)<=$(vD_YTD_To)\\"},\\n    [Facts.Keyfigure] = {Sales},\\n    [Facts.Valuetype] = {Amount},\\n    [Facts.Datetype] = {FC1}\\n\\t >}\\n     \\n[Facts.Value]\\n)","type":"sense"},"tags":[],"description":"","scalingGroup":"EUR","rules":[{"instanceOf":"DataMeasureRule","name":"New 0","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"type":"amount","value":"normal","factor":{"instanceOf":"Expression","formula":"1000","type":"tc"},"decimals":{"instanceOf":"Expression","formula":"0","type":"tc"},"unit":{"instanceOf":"Expression","formula":"","type":"tc"},"invertRating":false,"invertSign":false,"base":{"instanceOf":"DataMeasureRuleSetBase","time":"future","scenario":"forecast","version":"FC0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0, 0, 0)","border":"rgb(0, 0, 0)","pattern":"rgb(0, 0, 0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}}},"reference":{"instanceOf":"DataMeasureRuleSetReference","time":"present","scenario":"actual","version":"ACT0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0, 0, 0)","border":"rgb(0, 0, 0)","pattern":"rgb(0, 0, 0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}},"isActive":false}}],"expressions":[{"instanceOf":"DataMeasureExpression","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"formula":{"instanceOf":"Expression","formula":"0","type":"tc"},"calculationType":"summation"}],"inlineCommentType":"","markedForDeletion":false,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr3","biColumnId":"MZyeB","name":{"instanceOf":"Expression","formula":"Sales Amount FC1","type":"sense"},"displayCondition":{"instanceOf":"Expression","formula":"","type":"tc"}},{"instanceOf":"DataMeasure","biName":{"instanceOf":"Expression","formula":"DeltaBUD","type":"sense"},"customName":{"instanceOf":"Expression","formula":"\u0394 BUD","type":"tc"},"originatesFromBI":true,"definition":{"instanceOf":"Expression","formula":"=([Sales Amount ACT] + [Sales Amount FC1]) - [Sales Amount BUD]","type":"sense"},"tags":["Delta"],"description":"","scalingGroup":"EUR","rules":[{"instanceOf":"DataMeasureRule","name":"New 0","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"type":"amount","value":"normal","factor":{"instanceOf":"Expression","formula":"1000","type":"tc"},"decimals":{"instanceOf":"Expression","formula":"0","type":"tc"},"unit":{"instanceOf":"Expression","formula":"","type":"tc"},"invertRating":false,"invertSign":false,"base":{"instanceOf":"DataMeasureRuleSetBase","time":"present","scenario":"actual","version":"ACT0","isDelta":true,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0,0,0)","border":"rgb(0,0,0)","pattern":"rgb(0,0,0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}}},"reference":{"instanceOf":"DataMeasureRuleSetReference","time":"present","scenario":"budget","version":"BUD0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0,0,0)","border":"rgb(0,0,0)","pattern":"rgb(0,0,0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}},"isActive":true}}],"expressions":[{"instanceOf":"DataMeasureExpression","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"formula":{"instanceOf":"Expression","formula":"0","type":"tc"},"calculationType":"summation"}],"inlineCommentType":"","markedForDeletion":false,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr4","biColumnId":"pUmL","name":{"instanceOf":"Expression","formula":"\u0394 BUD","type":"tc"},"displayCondition":{"instanceOf":"Expression","formula":"","type":"tc"}},{"instanceOf":"DataMeasure","biName":{"instanceOf":"Expression","formula":"DeltaBUD%","type":"sense"},"customName":{"instanceOf":"Expression","formula":"\u0394 BUD%","type":"tc"},"originatesFromBI":true,"definition":{"instanceOf":"Expression","formula":"=(([Sales Amount ACT] + [Sales Amount FC1]) - [Sales Amount BUD])/[Sales Amount BUD]","type":"sense"},"tags":["Delta"],"description":"","scalingGroup":"Percent","rules":[{"instanceOf":"DataMeasureRule","name":"New 0","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"condition":{"instanceOf":"Expression","formula":"","type":"tc"},"type":"amount","value":"normal","factor":{"instanceOf":"Expression","formula":"0.01","type":"tc"},"decimals":{"instanceOf":"Expression","formula":"1","type":"tc"},"unit":{"instanceOf":"Expression","formula":"","type":"tc"},"invertRating":false,"invertSign":false,"base":{"instanceOf":"DataMeasureRuleSetBase","time":"present","scenario":"actual","version":"ACT0","isDelta":true,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0,0,0)","border":"rgb(0,0,0)","pattern":"rgb(0,0,0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}}},"reference":{"instanceOf":"DataMeasureRuleSetReference","time":"present","scenario":"budget","version":"BUD0","isDelta":false,"isIndividual":false,"color":{"instanceOf":"DataMeasureRuleSetColor","negative":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(255, 0, 0)","border":"rgb(255, 0, 0)","pattern":"rgb(255, 0, 0)"},"neutral":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(0,0,0)","border":"rgb(0,0,0)","pattern":"rgb(0,0,0)"},"positive":{"instanceOf":"DataMeasureRuleSetColorEntry","background":"rgb(140, 180, 0)","border":"rgb(140, 180, 0)","pattern":"rgb(140, 180, 0)"}},"isActive":true}}],"expressions":[{"instanceOf":"DataMeasureExpression","appliesToCondition":{"instanceOf":"Expression","formula":"","type":"tc"},"formula":{"instanceOf":"Expression","formula":"0","type":"tc"},"calculationType":"summation"}],"inlineCommentType":"","markedForDeletion":false,"id":"3e6734c0d21070831b886a17594425a61e750edd.ctx1.expr5","biColumnId":"GngBgs","name":{"instanceOf":"Expression","formula":"\u0394 BUD%","type":"tc"},"displayCondition":{"instanceOf":"Expression","formula":"","type":"tc"}}]}],"variables":[],"commonTables":[],"comments":[]}}')}}]);