(window["webpackJsonptrueChart"]=window["webpackJsonptrueChart"]||[]).push([[4],{555:function(e){e.exports={meta:{id:"",author:"www.trueChart.com",date:"26/08/2018 09:41:39",lastModifiedAt:"26/08/2018 09:41:39",isPublic:false,canUpdate:true,isBaseTemplate:true,tcversion:"2018.8.0",modelversion:"1",title:"Structure chart with deltas",description:"Creates a structure chart (actual, buget, forecast) with delta as waterfall and % values.",tags:["structure","variance","delta"],thumbnail:"data:image/png;base64,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",supportinfo:"sense"},data:{content:{instanceOf:"CellContainer",cells:[{instanceOf:"Cell",guid:"26304a94-17bf-93c4-4b29-3649c96bb434",name:"",id:"chartgrid01",isVisibleCondition:{instanceOf:"Expression",formula:"",type:"tc"},isBoxUniform:false,padding:{instanceOf:"PaddingBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},margin:{instanceOf:"MarginBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},border:{instanceOf:"BorderBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true,color:{instanceOf:"BorderBoxColor",uniform:"rgb(0, 0, 0)",top:"rgb(0, 0, 0)",right:"rgb(0, 0, 0)",bottom:"rgb(0, 0, 0)",left:"rgb(0, 0, 0)"}},alignment:{horizontal:"center",vertical:"center"},allowScrolling:true,allowBISelection:true,title:{instanceOf:"CellTitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No title",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"title"},subtitle:{instanceOf:"CellSubtitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No subtitle",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"subtitle"},triggers:[],navigationVariable:{instanceOf:"NavigationVariable",variable:"",auto:true,value:"",useQVNav:true,customClickBehavior:"// this example shows how to use clickInfos for performing a sense selection and sheet navigation (if not in mashUp)\n//\n// clickInfo.variableValue contains string info about clicked element\n// in the following format:\n//    <Dimension1_name>##<Dimension1_value>§§<Dimenison2_name>##<Dimension2_value>%%<Keyfigure_name>$$<Keyfigure_value>\n//\n// for example:\n//    DD_ProdCat_ProdName##Fashion for Women or\n//    DD_ProdCat_ProdName##0-3 Years§§Time_Month##12%%AC/ΔBU$$-10697858.838721484\n\n/*console.log( clickInfo.variableValue );\n\nif( clickInfo && clickInfo.variableValueAuto )\n{\n   var strSplit = clickInfo.variableValue.split('##')[1].split('§§')[0];\n\n   // select clicked D_ProdCat category\n   qlik.currApp().field(\"D_ProdCat\").selectValues([strSplit], false, false );\n\n   // open sheet 'correct scaling' if we're not in a mashup\n   if( !contextType.isMashup )\n   {\n      qlik.navigation.gotoSheet('zjjKdBx');\n   }\n}*/",check:{default:true,custom:false}},background:{instanceOf:"CellBackground",url:{instanceOf:"Expression",formula:"",type:"tc"},isActive:true,color:"#ffffff",repeat:"no-repeat",positionX:"center",positionY:"center",size:"auto",opacity:"1"},content:{instanceOf:"Grid",cellContainers:[{instanceOf:"CellContainer",cells:[{instanceOf:"Cell",guid:"472c3e72-b59a-4c61-4994-58cc74c7651f",name:"",id:"chart2",isVisibleCondition:{instanceOf:"Expression",formula:"",type:"tc"},isBoxUniform:false,padding:{instanceOf:"PaddingBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},margin:{instanceOf:"MarginBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},border:{instanceOf:"BorderBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true,color:{instanceOf:"BorderBoxColor",uniform:"rgb(0, 0, 0)",top:"rgb(0, 0, 0)",right:"rgb(0, 0, 0)",bottom:"rgb(0, 0, 0)",left:"rgb(0, 0, 0)"}},alignment:{horizontal:"center",vertical:"center"},allowScrolling:true,allowBISelection:true,title:{instanceOf:"CellTitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No title",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"title"},subtitle:{instanceOf:"CellSubtitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No subtitle",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"subtitle"},triggers:[],navigationVariable:{instanceOf:"NavigationVariable",variable:"",auto:true,value:"",useQVNav:true,customClickBehavior:"// this example shows how to use clickInfos for performing a sense selection and sheet navigation (if not in mashUp)\n//\n// clickInfo.variableValue contains string info about clicked element\n// in the following format:\n//    <Dimension1_name>##<Dimension1_value>§§<Dimenison2_name>##<Dimension2_value>%%<Keyfigure_name>$$<Keyfigure_value>\n//\n// for example:\n//    DD_ProdCat_ProdName##Fashion for Women or\n//    DD_ProdCat_ProdName##0-3 Years§§Time_Month##12%%AC/ΔBU$$-10697858.838721484\n\n/*console.log( clickInfo.variableValue );\n\nif( clickInfo && clickInfo.variableValueAuto )\n{\n   var strSplit = clickInfo.variableValue.split('##')[1].split('§§')[0];\n\n   // select clicked D_ProdCat category\n   qlik.currApp().field(\"D_ProdCat\").selectValues([strSplit], false, false );\n\n   // open sheet 'correct scaling' if we're not in a mashup\n   if( !contextType.isMashup )\n   {\n      qlik.navigation.gotoSheet('zjjKdBx');\n   }\n}*/",check:{default:true,custom:false}},background:{instanceOf:"CellBackground",url:{instanceOf:"Expression",formula:"",type:"tc"},isActive:true,color:"#ffffff",repeat:"no-repeat",positionX:"center",positionY:"center",size:"auto",opacity:"1"},content:{instanceOf:"Grid",cellContainers:[{instanceOf:"CellContainer",cells:[{instanceOf:"Cell",guid:"39f95ef8-8a78-9d2e-4940-632461314e39",name:"",id:"chart3",isVisibleCondition:{instanceOf:"Expression",formula:"",type:"tc"},isBoxUniform:false,padding:{instanceOf:"PaddingBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},margin:{instanceOf:"MarginBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},border:{instanceOf:"BorderBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true,color:{instanceOf:"BorderBoxColor",uniform:"rgb(0, 0, 0)",top:"rgb(0, 0, 0)",right:"rgb(0, 0, 0)",bottom:"rgb(0, 0, 0)",left:"rgb(0, 0, 0)"}},alignment:{horizontal:"center",vertical:"center"},allowScrolling:true,allowBISelection:true,title:{instanceOf:"CellTitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No title",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"title"},subtitle:{instanceOf:"CellSubtitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No subtitle",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"subtitle"},triggers:[],navigationVariable:{instanceOf:"NavigationVariable",variable:"",auto:true,value:"",useQVNav:true,customClickBehavior:"// this example shows how to use clickInfos for performing a sense selection and sheet navigation (if not in mashUp)\n//\n// clickInfo.variableValue contains string info about clicked element\n// in the following format:\n//    <Dimension1_name>##<Dimension1_value>§§<Dimenison2_name>##<Dimension2_value>%%<Keyfigure_name>$$<Keyfigure_value>\n//\n// for example:\n//    DD_ProdCat_ProdName##Fashion for Women or\n//    DD_ProdCat_ProdName##0-3 Years§§Time_Month##12%%AC/ΔBU$$-10697858.838721484\n\n/*console.log( clickInfo.variableValue );\n\nif( clickInfo && clickInfo.variableValueAuto )\n{\n   var strSplit = clickInfo.variableValue.split('##')[1].split('§§')[0];\n\n   // select clicked D_ProdCat category\n   qlik.currApp().field(\"D_ProdCat\").selectValues([strSplit], false, false );\n\n   // open sheet 'correct scaling' if we're not in a mashup\n   if( !contextType.isMashup )\n   {\n      qlik.navigation.gotoSheet('zjjKdBx');\n   }\n}*/",check:{default:true,custom:false}},background:{instanceOf:"CellBackground",url:{instanceOf:"Expression",formula:"",type:"tc"},isActive:false,color:"#ffffff",repeat:"no-repeat",positionX:"center",positionY:"center",size:"auto",opacity:"1"},content:{instanceOf:"Grid",cellContainers:[{instanceOf:"CellContainer",cells:[{instanceOf:"Cell",guid:"6768b108-e9aa-c446-498b-f366c91083a1",name:"",id:"chart4",isVisibleCondition:{instanceOf:"Expression",formula:"",type:"tc"},isBoxUniform:false,padding:{instanceOf:"PaddingBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},margin:{instanceOf:"MarginBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},border:{instanceOf:"BorderBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true,color:{instanceOf:"BorderBoxColor",uniform:"rgb(0, 0, 0)",top:"rgb(0, 0, 0)",right:"rgb(0, 0, 0)",bottom:"rgb(0, 0, 0)",left:"rgb(0, 0, 0)"}},alignment:{horizontal:"center",vertical:"center"},allowScrolling:true,allowBISelection:true,title:{instanceOf:"CellTitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No title",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"title"},subtitle:{instanceOf:"CellSubtitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No subtitle",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"subtitle"},triggers:[{instanceOf:"Trigger",type:"click",name:"",actions:[{instanceOf:"TriggerAction",inOrder:false,name:"none",paramsExpr:{},optionalParamsExpr:[]}]}],navigationVariable:{instanceOf:"NavigationVariable",variable:"",auto:true,value:"",useQVNav:true,customClickBehavior:"// this example shows how to use clickInfos for performing a sense selection and sheet navigation (if not in mashUp)\n//\n// clickInfo.variableValue contains string info about clicked element\n// in the following format:\n//    <Dimension1_name>##<Dimension1_value>§§<Dimenison2_name>##<Dimension2_value>%%<Keyfigure_name>$$<Keyfigure_value>\n//\n// for example:\n//    DD_ProdCat_ProdName##Fashion for Women or\n//    DD_ProdCat_ProdName##0-3 Years§§Time_Month##12%%AC/ΔBU$$-10697858.838721484\n\n/*console.log( clickInfo.variableValue );\n\nif( clickInfo && clickInfo.variableValueAuto )\n{\n   var strSplit = clickInfo.variableValue.split('##')[1].split('§§')[0];\n\n   // select clicked D_ProdCat category\n   qlik.currApp().field(\"D_ProdCat\").selectValues([strSplit], false, false );\n\n   // open sheet 'correct scaling' if we're not in a mashup\n   if( !contextType.isMashup )\n   {\n      qlik.navigation.gotoSheet('zjjKdBx');\n   }\n}*/",check:{default:true,custom:false}},background:{instanceOf:"CellBackground",url:{instanceOf:"Expression",formula:"",type:"tc"},isActive:false,color:"#ffffff",repeat:"no-repeat",positionX:"center",positionY:"center",size:"auto",opacity:"1"},content:{instanceOf:"Button",type:"simple",state:{instanceOf:"Expression",formula:"normal",type:"sense"},icon:{instanceOf:"Expression",formula:"fa-th-list",type:"sense"},label:{instanceOf:"Expression",formula:"Chart Title with Symbol",type:"sense"},tooltip:{instanceOf:"Expression",formula:"",type:"sense"},layout:{instanceOf:"ButtonLayout",size:{instanceOf:"ButtonSize",width:"",height:""},alignment:{instanceOf:"ButtonLayoutAlignment",buttonHorizontal:"center",buttonVertical:"center",contentHorizontal:"left",contentVertical:"center"},textAlignment:"center",iconPosition:"left",padding:"",margin:""},style:{instanceOf:"ButtonStyle",custom:{instanceOf:"Expression",formula:"",type:"sense"},font:{instanceOf:"ButtonStyleFont",family:{instanceOf:"Expression",formula:"",type:"sense"},weight:{instanceOf:"Expression",formula:"",type:"sense"},style:{instanceOf:"Expression",formula:"",type:"sense"},size:{instanceOf:"Expression",formula:"",type:"sense"},color:{instanceOf:"ButtonColor",default:{instanceOf:"Expression",formula:"",type:"sense"},hover:{instanceOf:"Expression",formula:"",type:"sense"}}},icon:{instanceOf:"ButtonStyleIcon",size:0,color:{instanceOf:"ButtonColor",default:{instanceOf:"Expression",formula:"",type:"sense"},hover:{instanceOf:"Expression",formula:"",type:"sense"}}},background:{instanceOf:"ButtonStyleBackground",image:{instanceOf:"Expression",formula:"../extensions/trueChart/img/logo.png",type:"sense"},position:{horizontal:"center",vertical:"center"},size:"",repeat:"no-repeat",color:{instanceOf:"ButtonColor",default:{instanceOf:"Expression",formula:"",type:"sense"},hover:{instanceOf:"Expression",formula:"=white()",type:"sense"}}},border:{instanceOf:"ButtonStyleBorder",color:{instanceOf:"ButtonColor",default:{instanceOf:"Expression",formula:"",type:"sense"},hover:{instanceOf:"Expression",formula:"",type:"sense"}},radius:"",width:"",style:"",enabled:"undefined"},boxShadow:""}}}]},{instanceOf:"CellContainer",cells:[{instanceOf:"Cell",guid:"4274b879-c936-15ff-4807-3e2d74d53040",name:"",id:"chart5",isVisibleCondition:{instanceOf:"Expression",formula:"",type:"tc"},isBoxUniform:false,padding:{instanceOf:"PaddingBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},margin:{instanceOf:"MarginBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},border:{instanceOf:"BorderBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true,color:{instanceOf:"BorderBoxColor",uniform:"#000000",top:"#000000",right:"#000000",bottom:"#000000",left:"#000000"}},alignment:{horizontal:"center",vertical:"center"},allowScrolling:true,allowBISelection:true,title:{instanceOf:"CellTitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No title",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"title"},subtitle:{instanceOf:"CellSubtitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No subtitle",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"subtitle"},triggers:[],navigationVariable:{instanceOf:"NavigationVariable",variable:"",auto:true,value:"",useQVNav:true,customClickBehavior:"// this example shows how to use clickInfos for performing a sense selection and sheet navigation (if not in mashUp)\n//\n// clickInfo.variableValue contains string info about clicked element\n// in the following format:\n//    <Dimension1_name>##<Dimension1_value>§§<Dimenison2_name>##<Dimension2_value>%%<Keyfigure_name>$$<Keyfigure_value>\n//\n// for example:\n//    DD_ProdCat_ProdName##Fashion for Women or\n//    DD_ProdCat_ProdName##0-3 Years§§Time_Month##12%%AC/ΔBU$$-10697858.838721484\n\n/*console.log( clickInfo.variableValue );\n\nif( clickInfo && clickInfo.variableValueAuto )\n{\n   var strSplit = clickInfo.variableValue.split('##')[1].split('§§')[0];\n\n   // select clicked D_ProdCat category\n   qlik.currApp().field(\"D_ProdCat\").selectValues([strSplit], false, false );\n\n   // open sheet 'correct scaling' if we're not in a mashup\n   if( !contextType.isMashup )\n   {\n      qlik.navigation.gotoSheet('zjjKdBx');\n   }\n}*/",check:{default:true,custom:false}},background:{instanceOf:"CellBackground",url:{instanceOf:"Expression",formula:"",type:"tc"},isActive:false,color:"#ffffff",repeat:"no-repeat",positionX:"center",positionY:"center",size:"auto",opacity:"1"},content:{instanceOf:"Grid",cellContainers:[{instanceOf:"CellContainer",cells:[{instanceOf:"Cell",guid:"26d436aa-892f-d22f-494f-bf002e8cb82e",name:"",id:"chart6",isVisibleCondition:{instanceOf:"Expression",formula:"",type:"tc"},isBoxUniform:false,padding:{instanceOf:"PaddingBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},margin:{instanceOf:"MarginBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},border:{instanceOf:"BorderBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true,color:{instanceOf:"BorderBoxColor",uniform:"#000000",top:"#000000",right:"#000000",bottom:"#000000",left:"#000000"}},alignment:{horizontal:"left",vertical:"center"},allowScrolling:true,allowBISelection:true,title:{instanceOf:"CellTitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No title",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"title"},subtitle:{instanceOf:"CellSubtitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No subtitle",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"subtitle"},triggers:[],navigationVariable:{instanceOf:"NavigationVariable",variable:"",auto:true,value:"",useQVNav:true,customClickBehavior:"",check:{default:true,custom:false}},background:{instanceOf:"CellBackground",url:{instanceOf:"Expression",formula:"",type:"tc"},isActive:false,color:"#ffffff",repeat:"no-repeat",positionX:"center",positionY:"center",size:"auto",opacity:"1"},content:{instanceOf:"StructureChart",contextId:"21f00043e-82d2-46e8-92d0-9c8d814fa31f00000",doStack:false,stack:{instanceOf:"ChartMeasureStack",type:"normal",showAsFormulas:[{instanceOf:"Formula",id:0,appliesTo:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"}}],label:{instanceOf:"ChartMeasureStackLabel",showAs:"none",position:"center",alignment:"inline",isVisible:true,showUnits:false,doesOverlapSelf:false,doesOverlapOthers:false},line:"none"},measures:[{instanceOf:"ChartMeasure",id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr0",name:"SalesAmount CY ACT + FC1",type:"bar",biColumnId:"mbYDb",showRestAsValue:true,showSubtotalAsValue:true,showTotalAsValue:true,notation:"element",concept:"area",valueLabelOpt:"all",valueLabelFunctions:[{instanceOf:"Formula",id:0,appliesTo:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"}}],valueLabelType:"normal",valueLabelBackground:"transparent",showUnit:true,outlier:{instanceOf:"MeasureOutlier",isActive:false,operator:">=",value:"",label:"value",useSymbol:true,style:"symbol_value"},scaling:{instanceOf:"MeasureScaling",isActive:false,legendShow:"none",legendDisplace:"none",showLegendSign:false},valueLabelOverlapSelf:true,valueLabelOverlapOthers:false,legend:{instanceOf:"ChartMeasureLegend",position:"none",displacement:"none",connector:"none",inGrid:true},reference:"Zero",referenceConcept:"area",labelPosition:"center",stackOrder:-1,sequence:1},{instanceOf:"ChartMeasure",id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr1",name:"SalesAmount CY BUD",type:"bar",biColumnId:"KjgBqs",showRestAsValue:true,showSubtotalAsValue:true,showTotalAsValue:true,notation:"element",concept:"area",valueLabelOpt:"none",valueLabelFunctions:[{instanceOf:"Formula",id:0,appliesTo:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"}}],valueLabelType:"normal",valueLabelBackground:"transparent",showUnit:true,outlier:{instanceOf:"MeasureOutlier",isActive:false,operator:">=",value:"",label:"value",useSymbol:true,style:"symbol_value"},scaling:{instanceOf:"MeasureScaling",isActive:false,legendShow:"none",legendDisplace:"none",showLegendSign:false},valueLabelOverlapSelf:true,valueLabelOverlapOthers:false,legend:{instanceOf:"ChartMeasureLegend",position:"none",displacement:"none",connector:"none",inGrid:true},reference:"Zero",referenceConcept:"area",labelPosition:"top",stackOrder:-1,sequence:1}],compares:[],highlights:[],categories:{instanceOf:"StructureCategory",showAt:"axis",gaps:[],categoriesWithoutTotals:"categoryWithoutValuesType.1",separator:{instanceOf:"CategorySeparator",category:false,timeType:false,scenario:false},labels:[{instanceOf:"CategoryLabel",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"},maxLength:-1,dimAutoLength:true,id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.dim0"}],additionalWidth:0,hasCategoryDistanceMultiplier:false,selectedMeasure:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr0",sepFromNotation:true,sepSubtotalFromNotation:true,sepTotalFromNotation:false,sepTotalWVFromNotation:true,sepLengthStartAuto:true,sepSubtotalLengthStartAuto:true,sepTotalLengthStartAuto:false,sepTotalWVLengthStartAuto:true,sepLengthStart_factor:100,sepLengthStart_mmpt:0,sepLengthStartUnit:"%",sepSubtotalLengthStart_factor:100,sepSubtotalLengthStart_mmpt:0,sepSubtotalLengthStartUnit:"%",sepTotalLengthStart_factor:50,sepTotalLengthStart_mmpt:0,sepTotalLengthStartUnit:"%",sepTotalWVLengthStart_factor:20,sepTotalWVLengthStart_mmpt:0,sepTotalWVLengthStartUnit:"%",sepEndFromNotation:true,sepSubtotalEndFromNotation:true,sepTotalEndFromNotation:false,sepTotalWVEndFromNotation:true,sepLengthEnd_factor:100,sepLengthEnd_mmpt:0,sepLengthEndUnit:"%",sepSubtotalLengthEnd_factor:100,sepSubtotalLengthEnd_mmpt:0,sepSubtotalLengthEndUnit:"%",sepTotalLengthEnd_factor:50,sepTotalLengthEnd_mmpt:0,sepTotalLengthEndUnit:"%",sepTotalWVLengthEnd_factor:20,sepTotalWVLengthEnd_mmpt:0,sepTotalWVLengthEndUnit:"%",alignment:{instanceOf:"StructureCategoryAlignment",horizontal:"left",vertical:"top"}}}}]},{instanceOf:"CellContainer",cells:[{instanceOf:"Cell",guid:"a427d4b2-74f1-7e8b-4b20-c339c936a791",name:"",id:"chart7",isVisibleCondition:{instanceOf:"Expression",formula:"",type:"tc"},isBoxUniform:false,padding:{instanceOf:"PaddingBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},margin:{instanceOf:"MarginBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},border:{instanceOf:"BorderBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true,color:{instanceOf:"BorderBoxColor",uniform:"#000000",top:"#000000",right:"#000000",bottom:"#000000",left:"#000000"}},alignment:{horizontal:"left",vertical:"center"},allowScrolling:true,allowBISelection:true,title:{instanceOf:"CellTitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No title",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"title"},subtitle:{instanceOf:"CellSubtitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No subtitle",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"subtitle"},triggers:[],navigationVariable:{instanceOf:"NavigationVariable",variable:"",auto:true,value:"",useQVNav:true,customClickBehavior:"",check:{default:true,custom:false}},background:{instanceOf:"CellBackground",url:{instanceOf:"Expression",formula:"",type:"tc"},isActive:false,color:"#ffffff",repeat:"no-repeat",positionX:"center",positionY:"center",size:"auto",opacity:"1"},content:{instanceOf:"StructureChart",contextId:"21f00043e-82d2-46e8-92d0-9c8d814fa31f00000",doStack:false,stack:{instanceOf:"ChartMeasureStack",type:"normal",showAsFormulas:[{instanceOf:"Formula",id:0,appliesTo:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"}}],label:{instanceOf:"ChartMeasureStackLabel",showAs:"none",position:"center",alignment:"inline",isVisible:true,showUnits:false,doesOverlapSelf:false,doesOverlapOthers:false},line:"none"},measures:[{instanceOf:"ChartMeasure",id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr2",name:"Δ BUD",type:"waterfall",biColumnId:"upqhNt",showRestAsValue:true,showSubtotalAsValue:true,showTotalAsValue:true,notation:"element",concept:"area_color",valueLabelOpt:"all",valueLabelFunctions:[{instanceOf:"Formula",id:0,appliesTo:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"}}],valueLabelType:"normal",valueLabelBackground:"transparent",showUnit:true,outlier:{instanceOf:"MeasureOutlier",isActive:false,operator:">=",value:"",label:"value",useSymbol:true,style:"symbol_value"},scaling:{instanceOf:"MeasureScaling",isActive:false,legendShow:"none",legendDisplace:"none",showLegendSign:false},valueLabelOverlapSelf:true,valueLabelOverlapOthers:false,legend:{instanceOf:"ChartMeasureLegend",position:"start_axis",displacement:"none",connector:"none",inGrid:true},reference:"Zero",referenceConcept:"area",labelPosition:"center",stackOrder:-1,sequence:1}],compares:[],highlights:[],categories:{instanceOf:"StructureCategory",showAt:"none",gaps:[],categoriesWithoutTotals:"categoryWithoutValuesType.1",separator:{instanceOf:"CategorySeparator",category:false,timeType:false,scenario:false},labels:[{instanceOf:"CategoryLabel",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"},maxLength:-1,dimAutoLength:true,id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.dim0"}],additionalWidth:0,hasCategoryDistanceMultiplier:false,selectedMeasure:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr0",sepFromNotation:true,sepSubtotalFromNotation:true,sepTotalFromNotation:false,sepTotalWVFromNotation:true,sepLengthStartAuto:true,sepSubtotalLengthStartAuto:true,sepTotalLengthStartAuto:false,sepTotalWVLengthStartAuto:true,sepLengthStart_factor:100,sepLengthStart_mmpt:0,sepLengthStartUnit:"%",sepSubtotalLengthStart_factor:100,sepSubtotalLengthStart_mmpt:0,sepSubtotalLengthStartUnit:"%",sepTotalLengthStart_factor:50,sepTotalLengthStart_mmpt:0,sepTotalLengthStartUnit:"%",sepTotalWVLengthStart_factor:20,sepTotalWVLengthStart_mmpt:0,sepTotalWVLengthStartUnit:"%",sepEndFromNotation:true,sepSubtotalEndFromNotation:true,sepTotalEndFromNotation:false,sepTotalWVEndFromNotation:true,sepLengthEnd_factor:100,sepLengthEnd_mmpt:0,sepLengthEndUnit:"%",sepSubtotalLengthEnd_factor:100,sepSubtotalLengthEnd_mmpt:0,sepSubtotalLengthEndUnit:"%",sepTotalLengthEnd_factor:50,sepTotalLengthEnd_mmpt:0,sepTotalLengthEndUnit:"%",sepTotalWVLengthEnd_factor:20,sepTotalWVLengthEnd_mmpt:0,sepTotalWVLengthEndUnit:"%",alignment:{instanceOf:"StructureCategoryAlignment",horizontal:"left",vertical:"top"}}}}]},{instanceOf:"CellContainer",cells:[{instanceOf:"Cell",guid:"812c71b4-3780-19da-4bf7-a3ca9f2239a5",name:"",id:"chart8",isVisibleCondition:{instanceOf:"Expression",formula:"",type:"tc"},isBoxUniform:false,padding:{instanceOf:"PaddingBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},margin:{instanceOf:"MarginBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true},border:{instanceOf:"BorderBox",width:{instanceOf:"BoxWidth",uniform:0,top:0,right:0,bottom:0,left:0},isActive:true,color:{instanceOf:"BorderBoxColor",uniform:"#000000",top:"#000000",right:"#000000",bottom:"#000000",left:"#000000"}},alignment:{horizontal:"left",vertical:"center"},allowScrolling:true,allowBISelection:true,title:{instanceOf:"CellTitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No title",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"title"},subtitle:{instanceOf:"CellSubtitle",keyCondition:"",isVisible:"true",isVisibleCondition:"Yes",isEditable:"true",isEditableCondition:"Yes",isAutoSave:true,text:"",defaultText:"No subtitle",showDefaultText:true,textType:"",loggable:true,isActive:false,transport:"active",titleLabelType:"subtitle"},triggers:[],navigationVariable:{instanceOf:"NavigationVariable",variable:"",auto:true,value:"",useQVNav:true,customClickBehavior:"",check:{default:true,custom:false}},background:{instanceOf:"CellBackground",url:{instanceOf:"Expression",formula:"",type:"tc"},isActive:false,color:"#ffffff",repeat:"no-repeat",positionX:"center",positionY:"center",size:"auto",opacity:"1"},content:{instanceOf:"StructureChart",contextId:"21f00043e-82d2-46e8-92d0-9c8d814fa31f00000",doStack:false,stack:{instanceOf:"ChartMeasureStack",type:"normal",showAsFormulas:[{instanceOf:"Formula",id:0,appliesTo:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"}}],label:{instanceOf:"ChartMeasureStackLabel",showAs:"none",position:"center",alignment:"inline",isVisible:true,showUnits:false,doesOverlapSelf:false,doesOverlapOthers:false},line:"none"},measures:[{instanceOf:"ChartMeasure",id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr3",name:"Δ BUD %",type:"value",biColumnId:"SGDPUgD",showRestAsValue:true,showSubtotalAsValue:true,showTotalAsValue:true,notation:"element",concept:"area_color",valueLabelOpt:"all",valueLabelFunctions:[{instanceOf:"Formula",id:0,appliesTo:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"}}],valueLabelType:"normal",valueLabelBackground:"transparent",showUnit:true,outlier:{instanceOf:"MeasureOutlier",isActive:false,operator:">=",value:"",label:"value",useSymbol:true,style:"symbol_value"},scaling:{instanceOf:"MeasureScaling",isActive:false,legendShow:"none",legendDisplace:"none",showLegendSign:false},valueLabelOverlapSelf:true,valueLabelOverlapOthers:false,legend:{instanceOf:"ChartMeasureLegend",position:"start_center",displacement:"none",connector:"none",inGrid:true},reference:"Zero",referenceConcept:"area",labelPosition:"center",stackOrder:-1,sequence:1}],compares:[],highlights:[],categories:{instanceOf:"StructureCategory",showAt:"none",gaps:[],categoriesWithoutTotals:"categoryWithoutValuesType.1",separator:{instanceOf:"CategorySeparator",category:false,timeType:false,scenario:false},labels:[{instanceOf:"CategoryLabel",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"},maxLength:-1,dimAutoLength:true,id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.dim0"}],additionalWidth:0,hasCategoryDistanceMultiplier:false,selectedMeasure:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr0",sepFromNotation:true,sepSubtotalFromNotation:true,sepTotalFromNotation:false,sepTotalWVFromNotation:true,sepLengthStartAuto:true,sepSubtotalLengthStartAuto:true,sepTotalLengthStartAuto:false,sepTotalWVLengthStartAuto:true,sepLengthStart_factor:100,sepLengthStart_mmpt:0,sepLengthStartUnit:"%",sepSubtotalLengthStart_factor:100,sepSubtotalLengthStart_mmpt:0,sepSubtotalLengthStartUnit:"%",sepTotalLengthStart_factor:50,sepTotalLengthStart_mmpt:0,sepTotalLengthStartUnit:"%",sepTotalWVLengthStart_factor:20,sepTotalWVLengthStart_mmpt:0,sepTotalWVLengthStartUnit:"%",sepEndFromNotation:true,sepSubtotalEndFromNotation:true,sepTotalEndFromNotation:false,sepTotalWVEndFromNotation:true,sepLengthEnd_factor:100,sepLengthEnd_mmpt:0,sepLengthEndUnit:"%",sepSubtotalLengthEnd_factor:100,sepSubtotalLengthEnd_mmpt:0,sepSubtotalLengthEndUnit:"%",sepTotalLengthEnd_factor:50,sepTotalLengthEnd_mmpt:0,sepTotalLengthEndUnit:"%",sepTotalWVLengthEnd_factor:20,sepTotalWVLengthEnd_mmpt:0,sepTotalWVLengthEndUnit:"%",alignment:{instanceOf:"StructureCategoryAlignment",horizontal:"left",vertical:"top"}}}}]}],columns:[{instanceOf:"GridDimensionColumn",size:{instanceOf:"GridDimensionSize",type:"w",value:4,minimum:25},isOptimizable:true},{instanceOf:"GridDimensionColumn",size:{instanceOf:"GridDimensionSize",type:"w",value:2,minimum:25},isOptimizable:true},{instanceOf:"GridDimensionColumn",size:{instanceOf:"GridDimensionSize",type:"w",value:1,minimum:25},isOptimizable:true}],rows:[{instanceOf:"GridDimensionRow",size:{instanceOf:"GridDimensionSize",type:"w",value:1,minimum:25},isOptimizable:true,wrapCells:false}]}}]}],columns:[{instanceOf:"GridDimensionColumn",size:{instanceOf:"GridDimensionSize",type:"w",value:1,minimum:25},isOptimizable:true}],rows:[{instanceOf:"GridDimensionRow",size:{instanceOf:"GridDimensionSize",type:"px",value:25,minimum:25},isOptimizable:false,wrapCells:false},{instanceOf:"GridDimensionRow",size:{instanceOf:"GridDimensionSize",type:"w",value:1,minimum:25},isOptimizable:true,wrapCells:false}]}}]}],columns:[{instanceOf:"GridDimensionColumn",size:{instanceOf:"GridDimensionSize",type:"w",value:1,minimum:25},isOptimizable:true}],rows:[{instanceOf:"GridDimensionRow",size:{instanceOf:"GridDimensionSize",type:"w",value:1,minimum:25},isOptimizable:true,wrapCells:false}]}}]}],columns:[{instanceOf:"GridDimensionColumn",size:{instanceOf:"GridDimensionSize",type:"w",value:1,minimum:25},isOptimizable:true}],rows:[{instanceOf:"GridDimensionRow",size:{instanceOf:"GridDimensionSize",type:"w",value:1,minimum:25},isOptimizable:true,wrapCells:false}]}}]},contentVersion:3,dataContexts:[{instanceOf:"DataContext",version:2,id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1",contextId:"21f00043e-82d2-46e8-92d0-9c8d814fa31f00000",name:"ProductGroup",tags:[],description:"",dimensionCounter:1,dimensions:[{instanceOf:"DataDimension",biName:{instanceOf:"Expression",formula:"Product Group",type:"sense"},customName:{instanceOf:"Expression",formula:"",type:"tc"},tags:[],description:"",definition:{instanceOf:"Expression",formula:"=[Items.Product Group Desc]",type:"sense"},showNullDimensions:true,timeFormat:{instanceOf:"DataDimensionTimeFormat",isActive:false,year:{instanceOf:"DataDimensionTimeFormatEntry",format:"none"},quarter:{instanceOf:"DataDimensionTimeFormatEntry",format:"none"},month:{instanceOf:"DataDimensionTimeFormatEntry",format:"none"},week:{instanceOf:"DataDimensionTimeFormatEntry",format:"none"},day:{instanceOf:"DataDimensionTimeFormatEntry",format:"none"}},sorting:{instanceOf:"DataDimensionSorting",isActive:true,order:"descending",unit:"%",value:100,target:"dimSortingTargetType.1",condition:{instanceOf:"Expression",formula:"",type:"tc"}},additions:{instanceOf:"DataDimensionAdditions",isFirstActive:false,isRestActive:true,isTotalActive:true,first:{instanceOf:"Expression",formula:"",type:"tc"},rest:{instanceOf:"Expression",formula:"Others",type:"tc"},total:{instanceOf:"Expression",formula:"Product Groups",type:"tc"},restOrder:"bottom",totalOrder:"bottom",showAsTotal:false,showHierarchically:false,additionsFirstBI:false,additionsRestBI:true,additionsTotalBI:true},drilldownDimensions:[],id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.dim0",biColumnId:"TjHFt",displayId:"D0100",subDimensionCounter:0,name:{instanceOf:"Expression",formula:"Product Group",type:"sense"}}],measures:[{instanceOf:"DataMeasure",biName:{instanceOf:"Expression",formula:"SalesAmount CY ACT + FC1",type:"sense"},customName:{instanceOf:"Expression",formula:"",type:"tc"},originatesFromBI:true,definition:{instanceOf:"Expression",formula:'sum( \r\n\t{<\n      $(vT_IgnoreSelections),\n    //[%Date]={">$(vD_ACM)<=$(vD_YTD_To)"},\n    [Calendar.BeginOfMonthNum]={">$(vD_ACM)<=$(vD_YTD_To)"},\n    [Facts.Keyfigure] = {Sales},\n    [Facts.Valuetype] = {Amount},\n    [Facts.Datetype] = {FC1}\n\t >}\n     \n[Facts.Value]\n)\n+\nsum(\n  {<\n    $(vT_IgnoreSelections),\n    //[%Date]={">=$(vD_YTD_From)<=$(vD_ACM)"},\n    [Calendar.BeginOfMonthNum]={">=$(vD_YTD_From)<=$(vD_ACM)"},\n    [Facts.Keyfigure] = {Sales},\n    [Facts.Valuetype] = {Amount},\n    [Facts.Datetype] = {ACT}\n  >} \n  [Facts.Value]\n)    ',type:"sense"},tags:[],description:"",scalingGroup:"EUR",rules:[{instanceOf:"DataMeasureRule",name:"New 0",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"},type:"amount",value:"normal",factor:{instanceOf:"Expression",formula:"1000",type:"tc"},decimals:{instanceOf:"Expression",formula:"0",type:"tc"},unit:{instanceOf:"Expression",formula:"",type:"tc"},invertRating:false,invertSign:false,base:{instanceOf:"DataMeasureRuleSetBase",time:"present",scenario:"forecast",version:"FC0",isDelta:false,isIndividual:false,color:{instanceOf:"DataMeasureRuleSetColor",negative:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(255, 0, 0)",border:"rgb(255, 0, 0)",pattern:"rgb(255, 0, 0)"},neutral:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(0,0,0)",border:"rgb(0,0,0)",pattern:"rgb(0,0,0)"},positive:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(140, 180, 0)",border:"rgb(140, 180, 0)",pattern:"rgb(140, 180, 0)"}}},reference:{instanceOf:"DataMeasureRuleSetReference",time:"present",scenario:"actual",version:"ACT0",isDelta:false,isIndividual:false,color:{instanceOf:"DataMeasureRuleSetColor",negative:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(255, 0, 0)",border:"rgb(255, 0, 0)",pattern:"rgb(255, 0, 0)"},neutral:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(0,0,0)",border:"rgb(0,0,0)",pattern:"rgb(0,0,0)"},positive:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(140, 180, 0)",border:"rgb(140, 180, 0)",pattern:"rgb(140, 180, 0)"}},isActive:false}}],expressions:[{instanceOf:"DataMeasureExpression",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},formula:{instanceOf:"Expression",formula:"0",type:"tc"},calculationType:"summation"}],inlineCommentType:"",markedForDeletion:false,id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr0",biColumnId:"mbYDb",name:{instanceOf:"Expression",formula:"SalesAmount CY ACT + FC1",type:"sense"}},{instanceOf:"DataMeasure",biName:{instanceOf:"Expression",formula:"SalesAmount CY BUD",type:"sense"},customName:{instanceOf:"Expression",formula:"",type:"tc"},originatesFromBI:true,definition:{instanceOf:"Expression",formula:'sum(\r\n  {<\n    $(vT_IgnoreSelections),\n    //[%Date]={">=$(vD_YTD_From)<=$(vD_YTD_To)"},\n    [Calendar.BeginOfMonthNum]={">=$(vD_YTD_From)<=$(vD_YTD_To)"},\n    [Facts.Keyfigure] = {Sales},\n    [Facts.Valuetype] = {Amount},\n    [Facts.Datetype] = {BUD}\n  >} \n  [Facts.Value]\n)    ',type:"sense"},tags:[],description:"",scalingGroup:"EUR",rules:[{instanceOf:"DataMeasureRule",name:"New 0",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"},type:"amount",value:"normal",factor:{instanceOf:"Expression",formula:"1000",type:"tc"},decimals:{instanceOf:"Expression",formula:"0",type:"tc"},unit:{instanceOf:"Expression",formula:"",type:"tc"},invertRating:false,invertSign:false,base:{instanceOf:"DataMeasureRuleSetBase",time:"present",scenario:"budget",version:"BUD0",isDelta:false,isIndividual:false,color:{instanceOf:"DataMeasureRuleSetColor",negative:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(255, 0, 0)",border:"rgb(255, 0, 0)",pattern:"rgb(255, 0, 0)"},neutral:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(0,0,0)",border:"rgb(0,0,0)",pattern:"rgb(0,0,0)"},positive:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(140, 180, 0)",border:"rgb(140, 180, 0)",pattern:"rgb(140, 180, 0)"}}},reference:{instanceOf:"DataMeasureRuleSetReference",time:"present",scenario:"actual",version:"ACT0",isDelta:false,isIndividual:false,color:{instanceOf:"DataMeasureRuleSetColor",negative:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(255, 0, 0)",border:"rgb(255, 0, 0)",pattern:"rgb(255, 0, 0)"},neutral:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(0,0,0)",border:"rgb(0,0,0)",pattern:"rgb(0,0,0)"},positive:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(140, 180, 0)",border:"rgb(140, 180, 0)",pattern:"rgb(140, 180, 0)"}},isActive:false}}],expressions:[{instanceOf:"DataMeasureExpression",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},formula:{instanceOf:"Expression",formula:"0",type:"tc"},calculationType:"summation"}],inlineCommentType:"",markedForDeletion:false,id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr1",biColumnId:"KjgBqs",name:{instanceOf:"Expression",formula:"SalesAmount CY BUD",type:"sense"}},{instanceOf:"DataMeasure",biName:{instanceOf:"Expression",formula:"DeltaBUD",type:"sense"},customName:{instanceOf:"Expression",formula:"Δ BUD",type:"tc"},originatesFromBI:true,definition:{instanceOf:"Expression",formula:"[SalesAmount CY ACT + FC1] - [SalesAmount CY BUD]",type:"sense"},tags:[],description:"",scalingGroup:"EUR",rules:[{instanceOf:"DataMeasureRule",name:"New 0",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"},type:"amount",value:"normal",factor:{instanceOf:"Expression",formula:"1000",type:"tc"},decimals:{instanceOf:"Expression",formula:"0",type:"tc"},unit:{instanceOf:"Expression",formula:"",type:"tc"},invertRating:false,invertSign:false,base:{instanceOf:"DataMeasureRuleSetBase",time:"present",scenario:"actual",version:"ACT0",isDelta:true,isIndividual:false,color:{instanceOf:"DataMeasureRuleSetColor",negative:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(255, 0, 0)",border:"rgb(255, 0, 0)",pattern:"rgb(255, 0, 0)"},neutral:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(0,0,0)",border:"rgb(0,0,0)",pattern:"rgb(0,0,0)"},positive:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(140, 180, 0)",border:"rgb(140, 180, 0)",pattern:"rgb(140, 180, 0)"}}},reference:{instanceOf:"DataMeasureRuleSetReference",time:"present",scenario:"actual",version:"ACT0",isDelta:false,isIndividual:false,color:{instanceOf:"DataMeasureRuleSetColor",negative:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(255, 0, 0)",border:"rgb(255, 0, 0)",pattern:"rgb(255, 0, 0)"},neutral:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(0,0,0)",border:"rgb(0,0,0)",pattern:"rgb(0,0,0)"},positive:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(140, 180, 0)",border:"rgb(140, 180, 0)",pattern:"rgb(140, 180, 0)"}},isActive:false}}],expressions:[{instanceOf:"DataMeasureExpression",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},formula:{instanceOf:"Expression",formula:"0",type:"tc"},calculationType:"summation"}],inlineCommentType:"",markedForDeletion:false,id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr2",biColumnId:"upqhNt",name:{instanceOf:"Expression",formula:"Δ BUD",type:"tc"}},{instanceOf:"DataMeasure",biName:{instanceOf:"Expression",formula:"DeltaBUD%",type:"sense"},customName:{instanceOf:"Expression",formula:"Δ BUD %",type:"tc"},originatesFromBI:true,definition:{instanceOf:"Expression",formula:"([SalesAmount CY ACT + FC1] - [SalesAmount CY BUD])/[SalesAmount CY BUD]",type:"sense"},tags:[],description:"",scalingGroup:"Percent",rules:[{instanceOf:"DataMeasureRule",name:"New 0",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},condition:{instanceOf:"Expression",formula:"",type:"tc"},type:"amount",value:"normal",factor:{instanceOf:"Expression",formula:"0.01",type:"tc"},decimals:{instanceOf:"Expression",formula:"1",type:"tc"},unit:{instanceOf:"Expression",formula:"",type:"tc"},invertRating:false,invertSign:false,base:{instanceOf:"DataMeasureRuleSetBase",time:"present",scenario:"actual",version:"ACT0",isDelta:true,isIndividual:false,color:{instanceOf:"DataMeasureRuleSetColor",negative:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(255, 0, 0)",border:"rgb(255, 0, 0)",pattern:"rgb(255, 0, 0)"},neutral:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(0,0,0)",border:"rgb(0,0,0)",pattern:"rgb(0,0,0)"},positive:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(140, 180, 0)",border:"rgb(140, 180, 0)",pattern:"rgb(140, 180, 0)"}}},reference:{instanceOf:"DataMeasureRuleSetReference",time:"present",scenario:"actual",version:"ACT0",isDelta:false,isIndividual:false,color:{instanceOf:"DataMeasureRuleSetColor",negative:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(255, 0, 0)",border:"rgb(255, 0, 0)",pattern:"rgb(255, 0, 0)"},neutral:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(0,0,0)",border:"rgb(0,0,0)",pattern:"rgb(0,0,0)"},positive:{instanceOf:"DataMeasureRuleSetColorEntry",background:"rgb(140, 180, 0)",border:"rgb(140, 180, 0)",pattern:"rgb(140, 180, 0)"}},isActive:false}}],expressions:[{instanceOf:"DataMeasureExpression",appliesToCondition:{instanceOf:"Expression",formula:"",type:"tc"},formula:{instanceOf:"Expression",formula:"0",type:"tc"},calculationType:"summation"}],inlineCommentType:"",markedForDeletion:false,id:"7f9cb87c15d0fc773dbb25eb7bbd8025436fc584.ctx1.expr3",biColumnId:"SGDPUgD",name:{instanceOf:"Expression",formula:"Δ BUD %",type:"tc"}}]}],variables:[],commonTables:[],comments:[]}}}}]);